<?php
require __DIR__ . '/../db.php';

$cols = [
  1 => 'Backlog',
  2 => 'Planned',
  3 => 'In Progress',
  4 => 'Released',
];

$data = [];
foreach ($cols as $sid => $name) {
  $rows = $db->queryAll(
    'SELECT f.*, COALESCE(tv.total_votes,0) AS total_votes, c.name AS category_name
     FROM features f
     LEFT JOIN (SELECT feature_id,COUNT(*) total_votes FROM feature_votes GROUP BY feature_id) tv
       ON tv.feature_id=f.id
     LEFT JOIN categories c ON c.id=f.category_id
     WHERE f.status_id=?
     ORDER BY total_votes DESC, f.created_at DESC',
    [$sid]
  );
  $data[$sid] = $rows;
}
?>
<!doctype html>
<html lang="en">
<head>
<meta charset="utf-8" />
<meta name="viewport" content="width=device-width,initial-scale=1" />
<title>Roadmap</title>
<style>
body{font-family:system-ui,-apple-system,Segoe UI,Roboto,Ubuntu;margin:0;background:#f6f7fb;color:#111827}
.wrap{max-width:1200px;margin:24px auto;padding:0 16px}
h1{margin-bottom:16px}
.board{display:grid;gap:12px}
@media (min-width:900px){
  .board{grid-template-columns:repeat(4,minmax(0,1fr));}
}
.col{background:#f3f4f6;border-radius:12px;padding:8px 8px 12px 8px;border:1px solid #e5e7eb;min-height:80px}
.col h2{font-size:16px;margin:4px 4px 8px 4px;display:flex;justify-content:space-between;align-items:center}
.card{background:#fff;border-radius:10px;border:1px solid #e5e7eb;padding:8px 10px;margin:0 4px 8px 4px;box-shadow:0 1px 2px rgba(0,0,0,.04);font-size:14px}
.badge{font-size:11px;border-radius:999px;border:1px solid #e5e7eb;padding:2px 6px;margin-left:4px}
.muted{color:#6b7280;font-size:12px}
</style>
</head>
<body>
<div class="wrap">
  <h1>Roadmap</h1>
  <p class="muted" style="margin-bottom:16px;">Columns show the current status of ideas. Card order is by total votes, then recency.</p>
  <div class="board">
    <?php foreach ($cols as $sid => $label): ?>
      <div class="col">
        <h2>
          <span><?php echo htmlspecialchars($label); ?></span>
          <span class="muted"><?php echo count($data[$sid] ?? []); ?> items</span>
        </h2>
        <?php if (empty($data[$sid])): ?>
          <div class="muted" style="margin:4px 6px;">No items yet.</div>
        <?php else: ?>
          <?php foreach ($data[$sid] as $f): ?>
            <div class="card">
              <div><strong><?php echo htmlspecialchars($f['title']); ?></strong>
                <?php if (!empty($f['category_name'])): ?>
                  <span class="badge"><?php echo htmlspecialchars($f['category_name']); ?></span>
                <?php endif; ?>
                <?php if (!empty($f['duplicate_of'])): ?>
                  <span class="badge">Dup of #<?php echo (int)$f['duplicate_of']; ?></span>
                <?php endif; ?>
              </div>
              <?php if (!empty($f['description'])): ?>
                <div class="muted"><?php echo nl2br(htmlspecialchars($f['description'])); ?></div>
              <?php endif; ?>
              <div class="muted">
                Votes: <?php echo (int)$f['total_votes']; ?> ·
                Created: <?php echo htmlspecialchars(substr($f['created_at'],0,10)); ?>
              </div>
            </div>
          <?php endforeach; ?>
        <?php endif; ?>
      </div>
    <?php endforeach; ?>
  </div>
</div>
</body>
</html>
